/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx__mcp_request_ring.c,v 1.9 2006/02/15 22:16:52 loic Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx_debug.h"
#include "mcp_requests.h"
#include "mx__mcp_request_ring.h"

void
mx__mcp_request_ring_init(struct mx__mcp_request_ring *ring, char *p,
			  int length)
{
  ring->base = (mcp_ureq_t*)p;
#if !MCP_USE_REQUEST_QUEUE
  ring->tail = 0;
  ring->max = length/sizeof (mcp_ureq_t);
  ring->mask = ring->max - 1;

  mx_assert((ring->max & ring->mask) == 0);
#endif
}
